@extends('layouts.front')
@push('styles')
<link rel="stylesheet" href="{{ asset('assets/css/form.css') }}">
@endpush
@section('content')
    <div class="container py-3">
        
        @foreach ($errors->all() as $error)
            <div class="alert alert-danger">
                {{ $error }}
            </div>
        @endforeach
        @if(session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif
        <!-- Form Container -->
        <div class="form-container">

            <div class="form-title">
                <i class="fas fa-file-invoice-dollar"></i> @lang('messages.complaint_form')
            </div>
            <!-- Progress Bar -->
            <div class="progress-container">
                <div class="progress-bar">
                    <div class="progress-fill" id="progressFill"></div>
                </div>
                <div class="progress-text" id="progressText">0% @lang('messages.complete')</div>
            </div>
            
            <!-- Form Content -->
            <form id="fundingForm" action="{{ route('plaintes.store') }}" method="POST" enctype="multipart/form-data" class="form-content my-3 needs-validation" novalidate>
                @csrf
                <input type="hidden" name="type_plainte" value="{{ $type_plainte }}">
                <input type="hidden" name="plaignant[type]" value="{{ $type_plaignant }}">
                <input type="hidden" name="est_anonyme" value="{{ $anonyme }}" >
                <input type="hidden" name="canal_reception" value="web" >
                <!-- Section 1: Informations de la plainte -->
                
                <div class="form-section">
                    <div class="section-header">
                        <i class="fas fa-building"></i>
                        <h3>@lang('messages.complainant_information')</h3>
                    </div>
                    @if(!$anonyme)
                    @if($type_plaignant=='individu')
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label required">@lang('messages.last_name')</label>
                            <input type="text" name="plaignant[nom]" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label">@lang('messages.first_name')</label>
                            <input type="text" name="plaignant[prenom]" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">@lang('messages.gender')</label>
                            <select name="plaignant[genre]" class="form-control" required>
                                <option value="M">@lang('messages.male')</option>
                                <option value="F">@lang('messages.female')</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label required">@lang('messages.address')</label>
                            <input type="text" name="plaignant[adresse]" class="form-control" required>
                        </div>
                    </div>
                    @elseif($type_plaignant=='groupe')
                    <div class="form-group">
                            <label class="form-label">@lang('messages.group_name')</label>
                        <input type="text" name="plaignant[nom]" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">@lang('messages.address')</label>
                        <input type="text" name="plaignant[adresse]" class="form-control" required>
                    </div>
                    
                    @elseif($type_plaignant=='communaute')
                    <div class="form-group">
                        <label class="form-label">@lang('messages.community_name')</label>
                        <input type="text" name="plaignant[nom]" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label class="form-label">@lang('messages.address')</label>
                        <input type="text" name="plaignant[adresse]" class="form-control" required>
                    </div>
                    @endif
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">@lang('messages.phone')</label>
                            <input type="tel" name="plaignant[telephone]" class="form-control">
                        </div>
                        <div class="form-group">
                            <label class="form-label">@lang('messages.email')</label>
                            <input type="email" name="plaignant[email]" class="form-control" required>
                        </div>
                        
                    </div>
                    @else
                    <div class="form-group">
                        <label class="form-label required">@lang('messages.email')</label>
                        <input type="email" name="plaignant[email]" class="form-control" required>
                        <small class="form-text text-muted">@lang('messages.email_hint')</small>
                    </div>
                    @endif
                </div>
                <!-- Section 2:  Détails de la Plainte -->
                <div class="form-section">
                    <div class="section-header">
                        <i class="fas fa-tasks"></i>
                        <h3>@lang('messages.complaint_details')</h3>
                    </div>
                    <div class="form-group">
                        <label class="form-label required">@lang('messages.complaint_object')</label>
                        <input type="text" name="objet" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label required">@lang('messages.complaint_description')</label>
                        <textarea name="description" class="form-control textarea" rows="5" required placeholder="@lang('messages.describe_complaint_placeholder')"></textarea>
                    </div>
                    

                </div>
                <!-- Section 3: Pièces Jointes -->
                <div class="form-section">
                    <div class="section-header">
                        <i class="fas fa-paperclip"></i>
                        <h3>@lang('messages.supporting_documents')</h3>
                    </div>

                    <div class="form-group">
                        <label class="form-label required">@lang('messages.complaint_supporting_documents')</label>
                        <input type="file" id="fileInput" name="preuves[]" class="file-input" 
                               accept=".pdf,.doc,.docx,.xls,.xlsx" multiple>
                        <div class="file-upload-area" onclick="document.getElementById('fileInput').click()">
                            <i class="fas fa-cloud-upload-alt"></i>
                            <h4>@lang('messages.click_to_upload')</h4>
                            <p>@lang('messages.accepted_formats'): PDF, DOC, DOCX, XLS, XLSX</p>
                            <p style="font-size: 0.9rem; color: #666;">@lang('messages.max_file_size')</p>
                        </div>
                        <div class="file-list" id="fileList"></div>
                        <div class="help-text">
                            <i class="fas fa-info-circle"></i>
                            @lang('messages.multiple_files_info')
                        </div>
                    </div>
                </div>
                <!-- Form Actions -->
                <div class="form-actions">
                    <a href="{{ route('home') }}" class="btn btn-secondary" >
                        <i class="fas fa-redo"></i>
                        @lang('messages.cancel')
                    </a>

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-paper-plane"></i>
                        @lang('messages.submit_request')
                    </button>
                </div>
            </form>
        </div>
    </div>

    

    
@endsection
@push('scripts')
   <script>
        // Progress tracking
        const form = document.getElementById('fundingForm');
        const progressFill = document.getElementById('progressFill');
        const progressText = document.getElementById('progressText');

        function updateProgress() {
            const inputs = form.querySelectorAll('input[required], textarea[required], select[required]');
            let filled = 0;
            
            inputs.forEach(input => {
                if (input.value.trim() !== '') {
                    filled++;
                }
            });
            
            const percentage = Math.round((filled / inputs.length) * 100);
            progressFill.style.width = percentage + '%';
            progressText.textContent = percentage + '% ' + '@lang('messages.complete')';
        }

        // Add event listeners to all form inputs
        form.addEventListener('input', updateProgress);
        form.addEventListener('change', updateProgress);

        // File upload handling
        const fileInput = document.getElementById('fileInput');
        const fileList = document.getElementById('fileList');
        let uploadedFiles = [];

        fileInput.addEventListener('change', function(e) {
            Array.from(e.target.files).forEach(file => {
                if (file.size > 10 * 1024 * 1024) {
                    alert(`@lang('messages.file_too_large') ${file.name}`);
                    return;
                }
                
                if (!uploadedFiles.find(f => f.name === file.name)) {
                    uploadedFiles.push(file);
                    addFileToList(file);
                }
            });
            updateProgress();
        });

        function addFileToList(file) {
            const fileItem = document.createElement('div');
            fileItem.className = 'file-item';
            fileItem.innerHTML = `
                <div class="file-item-info">
                    <i class="fas fa-file-${getFileIcon(file.name)}"></i>
                    <span>${file.name} (${(file.size / 1024 / 1024).toFixed(2)} MB)</span>
                </div>
                <button type="button" class="remove-file" onclick="removeFile('${file.name}')">
                    <i class="fas fa-times"></i>
                </button>
            `;
            fileList.appendChild(fileItem);
        }

        function getFileIcon(filename) {
            const ext = filename.split('.').pop().toLowerCase();
            const icons = {
                'pdf': 'pdf',
                'doc': 'word',
                'docx': 'word',
                'xls': 'excel',
                'xlsx': 'excel'
            };
            return icons[ext] || 'alt';
        }

        function removeFile(filename) {
            uploadedFiles = uploadedFiles.filter(f => f.name !== filename);
            const items = fileList.querySelectorAll('.file-item');
            items.forEach(item => {
                if (item.textContent.includes(filename)) {
                    item.remove();
                }
            });
            updateProgress();
        }




        // Validate numeric inputs
        const numericInputs = form.querySelectorAll('input[type="number"]');
        numericInputs.forEach(input => {
            input.addEventListener('input', function() {
                if (this.value < 0) {
                    this.value = 0;
                }
            });
        });

        

        // Initialize progress on load
        updateProgress();

        // Smooth scroll to top button
        window.addEventListener('scroll', function() {
            const scrollBtn = document.getElementById('scrollTopBtn');
            if (!scrollBtn) {
                const btn = document.createElement('button');
                btn.id = 'scrollTopBtn';
                btn.innerHTML = '<i class="fas fa-arrow-up"></i>';
                btn.style.cssText = `
                    position: fixed;
                    bottom: 2rem;
                    right: 2rem;
                    width: 50px;
                    height: 50px;
                    border-radius: 50%;
                    background: linear-gradient(135deg, #2e8b57, #228b22);
                    color: white;
                    border: none;
                    cursor: pointer;
                    display: none;
                    align-items: center;
                    justify-content: center;
                    font-size: 1.2rem;
                    box-shadow: 0 4px 15px rgba(46, 139, 87, 0.3);
                    transition: all 0.3s ease;
                    z-index: 1000;
                `;
                btn.addEventListener('click', function() {
                    window.scrollTo({ top: 0, behavior: 'smooth' });
                });
                document.body.appendChild(btn);
            }
            
            const scrollTopBtn = document.getElementById('scrollTopBtn');
            if (window.pageYOffset > 300) {
                scrollTopBtn.style.display = 'flex';
            } else {
                scrollTopBtn.style.display = 'none';
            }
        });
    </script> 
    <script>
        (function () {
            'use strict'
            var forms = document.querySelectorAll('.needs-validation')
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
@endpush
